
// This scilab code is used to perform basic operation such as binarization of images 
//that contains text with random value of threshold

//The scilab environment for this is : Scilab 6.0.1

//Toolbox used: Image Processing and Computer Vision Toolbox ver. 1.1
              

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

//clc //to clear command window.
clear all //to kill previously defined variables.
//xdel(winsid())//to close all currently open figure(s).

//This code uses text.png, region.png and number.png image files for processing

img = imread('text.png');               // Reads input image
threshold=0.93;                         // set a random threshold value
imagen =~im2bw(img,threshold);            // Convert input image to binarized image with given threshold
                                        // and also negate the output
imshow(imagen);                         // Shows the resultant image (exp_11_1_result_1.png)

img = imread('number.png');               // Reads input image
threshold=0.93;                         // set a random threshold value
imagen =~im2bw(img,threshold);            // Convert input image to binarized image with given threshold
                                        // and also negate the output
imshow(imagen);                         // Shows the resultant image (exp_11_1_result_2.png)

img = imread('region.png');               // Reads input image
threshold=0.93;                         // set a random threshold value
imagen =~im2bw(img,threshold);            // Convert input image to binarized image with given threshold
                                        // and also negate the output
imshow(imagen);                         // Shows the resultant image (exp_11_1_result_3.png)
